/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CThreadImpWin32.cpp,v 1.1 1999/09/12 04:29:49 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include <process.h>

#include "CThreadImpWin32.h"

_USING_PGP

// Class CThreadImpWin32 private member functions

void 
CThreadImpWin32::StartOsThread()
{
	// KB Q104641
	if (_beginthread(MainThreadFunction, 0, this) == -1)
		THROW_PGPERROR(kPGPError_ThreadOpFailed);
}

void 
CThreadImpWin32::MainThreadFunctionAux()
{
	while (TRUE)
	{
		try
		{
			// Call the main loop function.
			if (!MainThreadLoop())
				break;
		}
		catch (CComboError&)
		{
			pgpDebugMsg("Uncaught exception in PGPdisk thread!");
		}
	}
}

void 
_cdecl 
CThreadImpWin32::MainThreadFunction(void *pUserData)
{
	CThreadImpWin32	*pThreadImpWin32	= 
		static_cast<CThreadImpWin32 *>(pUserData);

	pgpAssertAddrValid(pThreadImpWin32, CThreadImpWin32);
	pThreadImpWin32->MainThreadFunctionAux();
}
